<%@ LANGUAGE="VBScript" %>

<% '***************************************************************************
   '* ASP Football Pool                                                       *
   '*                                                                         *
   '* Copyright 2000 by Mike Hall                                             *
   '* Please see http://www.brainjar.com for documentation and terms of use.  *
   '***************************************************************************
%>

<!-- #include file="protect.inc" -->
<!-- #include file="common.inc" -->
<!-- #include file="header.inc" -->

<% found = false

   'Open the database.

   call OpenDB()

   'Create an array of user objects.

   dim users
   n = NumberOfUsers()
   redim users(n - 1)

   sql = "select *" _
      & " from Users" _
      & " where Username <> '" & ADMIN_USERNAME & "'" _
      & " order by Username"
   set rs = DbConn.Execute(sql)
   if not (rs.EOF and rs.BOF) then
     i = 0
     do while not rs.EOF
       set users(i) = new UserObj
       users(i).setData(rs.Fields("Username").Value)
       i = i + 1
       rs.MoveNext
     loop
   end if

   'List the winners for each week.

   first = true
   for i = 1 to NumberOfWeeks()
     list = WinnersList(i)
     if IsArray(list) then
       if first then
         first = false %>
<h4>Weeky Winners</h4>

<p><table class="formatted" cellpadding=0 cellspacing=0>
<tr>
  <th align=right>Week&nbsp;</th>
  <th>Winner&nbsp;</th>
  <th>Score&nbsp;</th>
  <th align=right>TB Diff.&nbsp;</th>
  <th align=right>Players&nbsp;</th>
  <th align=right>Pot&nbsp;</th>
</tr>
<%     end if
       if Round(i / 2) * 2 <> i then %>
<tr>
<%     else %>
<tr class="alt">
<%     end if
       entries = NumberOfEntries(i)
       score = UserScore(list(0), i)
       games = NumberOfGames(i)
       pct = FormatPercent(score / games)
       diff = Abs(TBPointTotal(i) - UserTBGuess(list(0), i))
       pot = BET_AMOUNT * entries
       str = ""
       for j = 0 to UBound(list)

         'Update total winnings for users in the winning list.

         for k = 0 to UBound(users)
           numWinners = Ubound(list) + 1
           if users(k).name = list(j) and numWinners <> 0 then
             users(k).weeksWon = users(k).weeksWon + 1 / numWinners
             users(k).totalWinnings = users(k).totalWinnings + pot / numWinners
           end if
         next

         'Build a string listing the names of all the week's winners.

         if j > 0 then
           str = str & ", "
         end if
         str = str & list(j)
       next %>
  <td align=right><% = i %>&nbsp;</td>
  <td><% = str %>&nbsp;</td>
  <td align=right><% = score %>/<% = games %> (<% = pct %>)&nbsp;</td>
  <td align=right><% = diff %>&nbsp;</td>
  <td align=right><% = entries %>&nbsp;</td>
  <td align=right><% = FormatAmount(pot) %>&nbsp;</td>
</tr>
<%   end if
   next
   if not first then %>
</table></p>
<% end if

   'Display individual statistics.

   if n = 0 then
     call ErrorMessage("No users found in database.")
   else %>
<h4>Individual Statistics</h4>

<p><table class="formatted" cellpadding=0 cellspacing=0>
<tr>
  <th>Name</th>
  <th align=right>Played&nbsp;</th>
  <th align=right>Won</th>
  <th align=right>Cost&nbsp;</th>
  <th align=right>Winnings&nbsp;</th>
  <th align=right>Total&nbsp;</th>
  <th align=right colspan=2>Overall Picks</th>
</tr>
<%   'List summary data for each player.

     for i = 0 to UBound(users)
       if Round(i / 2) * 2 = i then %>
<tr>
<%       else %>
<tr class="alt">
<%       end if
         cost =  users(i).weeksPlayed * BET_AMOUNT
         total = users(i).totalWinnings - cost
         if users(i).totalGames <> 0 then
           pct = "(" & FormatPercent(users(i).totalCorrect / users(i).totalGames) & ")"
         else
           pct = ""
         end if %>
  <td><% = users(i).name %>&nbsp;</td>
  <td align=right><% = users(i).weeksPlayed %>&nbsp;</td>
  <td align=right><% = users(i).weeksWon %>&nbsp;</td>
  <td align=right><% = FormatAmount(cost) %>&nbsp;</td>
  <td align=right><% = FormatAmount(users(i).totalWinnings) %>&nbsp;</td>
  <td align=right><% = FormatAmount(total) %>&nbsp;</td>
  <td align=right><% = users(i).totalCorrect & "/" & users(i).totalGames %>&nbsp;</td>
  <td align=right><% = pct %>&nbsp;</td>
</tr>
<%   next %>
</table></p>
<% end if %>

<!-- #include file="footer.inc" -->

<% '***************************************************************************
   '* Local class definitions.                                                      *
   '***************************************************************************

   '---------------------------------------------------------------------------
   ' UserObj: Used to hold data for an individual user.
   '---------------------------------------------------------------------------

   class UserObj

     public name
     public weeksPlayed
     public weeksWon
     public totalCorrect
     public totalGames
     public totalWinnings

     private sub Class_Initialize()
     end sub

     private sub Class_Terminate()
     end sub

     public sub setData(username)

       dim sql, rs, week

       name = username

       'Find the number of weeks this user has participated in. Count entries
       'only up to the last week with game results.

       sql = "select max(week) as last" _
          & " from Schedule" _
          & " where Result <> ''"
       set rs = DbConn.Execute(sql)
       if not (rs.BOF and rs.EOF) then
         week = rs.Fields("last").Value
         sql = "select count(*) as total" _
            & " from TieBreaker" _
            & " where Username = '" & username & "'" _
            & " and Week <= " & week
         set rs = DbConn.Execute(sql)
         if not (rs.BOF and rs.EOF) then
           weeksPlayed = rs.Fields("total").Value
         end if
       end if

       'Find the number of correct picks this user has made for all games
       'played.

       sql = "select count(*) as total" _
          & " from Picks, Schedule" _
          & " where Username = '" & username & "'" _
          & " and Picks.GameID = Schedule.GameID" _
          & " and Picks.Pick = Schedule.Result" _
          & " and Schedule.Result <> ''"
       set rs = DbConn.Execute(sql)
       if not (rs.BOF and rs.EOF) then
         totalCorrect = rs.Fields("total").Value
       end if

       'Find the total number of picks this user has made for all games played.

       sql = "select count(*) as total" _
          & " from Picks, Schedule" _
          & " where Username = '" & username & "'" _
          & " and Picks.GameID = Schedule.GameID" _
          & " and Schedule.Result <> ''"
       set rs = DbConn.Execute(sql)
       if not (rs.BOF and rs.EOF) then
         totalGames = rs.Fields("total").Value
       end if

       'Initialize remaining properties.

       weeksWon = 0
       totalWinnings = 0

     end sub

   end class %>
